package gov.va.vamf.scheduling.direct.datalayer.profile;

import com.agilex.healthcare.directscheduling.datalayer.SchedulingDataLayerMdws;
import com.agilex.healthcare.directscheduling.dataservice.DSDataService;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import gov.va.vamf.scheduling.direct.domain.ClinicProfile;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class ClinicProfileService {

    @Resource
    SchedulingDataLayerMdws schedulingDataLayer;
    @Resource
    DSDataService dsDataService;


    public ClinicProfile fetchClinicProfile(String siteCode, String clinicId, PatientIdentifier patientIdentifier) {

        PatientIdentifier icnPatientIdentifier = dsDataService.getIcnIdentifiers(patientIdentifier);
        if (icnPatientIdentifier == null) {
            return (null);
        }

        return schedulingDataLayer.getClinicProfile(siteCode, clinicId, icnPatientIdentifier);
    }
}
